import zipfile
import os
from pathlib import Path
import shutil

FOLDER_PREFIX = "unzip_"
OUTPUT_DIR = Path("c:/dev/recurse/extraction_result")  # répertoire de destination

# Identification des fichiers ZIP d'un répertoire
def lister_zip_pathlib(repertoire):
    """Retourne la liste des fichiers .zip dans un répertoire."""
    rep = Path(repertoire)
    return [f for f in rep.iterdir() if f.is_file() and f.suffix.lower() == ".zip"]

# Décompression d'un fichier zip dans le répertoire "extract_to"
def unzip_file(zip_path, extract_to, debug=True):
    """
    Décompresse un fichier ZIP dans un répertoire donné.
    
    :param zip_path: Chemin du fichier ZIP
    :param extract_to: Répertoire où extraire les fichiers
    """
    if debug:
        print (f"Décompression de {zip_path} vers {extract_to}")

    # Crée le répertoire si nécessaire
    os.makedirs(extract_to, exist_ok=True)

    # Ouvre et extrait le fichier zip
    with zipfile.ZipFile(zip_path, 'r') as zip_ref:
        zip_ref.extractall(extract_to)
        if debug:
            print(f"✅ Fichiers extraits dans : {extract_to}")

def recurse_unzip (path, folder_num):
  
    liste_zip = lister_zip_pathlib(path)
    print (f"Liste des fichiers zip de {path} : {liste_zip}")

    for myzip in liste_zip:

        folder_num[0] += 1
        mydir = OUTPUT_DIR / f"{FOLDER_PREFIX}{folder_num[0]:04d}"
        print (f"Décompression de : {myzip}")
        input()

        unzip_file(myzip, mydir)
        recurse_unzip (mydir, folder_num)

zip_file = "c:/dev/recurse/example_nested.zip"   # chemin vers ton fichier zip

# Supprime tout le dossier
if OUTPUT_DIR.exists():
    shutil.rmtree(OUTPUT_DIR)

# Recréé le dossier
OUTPUT_DIR.mkdir(parents=True, exist_ok=True)

# 1er niveau 
# On utilise un objet mutable afin d'utilisé le passage par adresse (pointeur) et non le passage par valeur 
folder_num=[0]
mydir = OUTPUT_DIR / f"{FOLDER_PREFIX}{folder_num[0]:04d}"

# Destruction du contenu 
unzip_file(zip_file, mydir)

# Récursivité
recurse_unzip (mydir, folder_num)